package sajous.litl.token;

import sajous.litl.colors.*;

public class TokenHTML extends Token
{
	private static ReferenceColor selectedTokenColor
		= new ReferenceColor(AbstractColor.COMPONENT_MAX_VALUE,
							AbstractColor.COMPONENT_MAX_VALUE,	
							0,
							"Yellow");
	
	private String fontFamily = "Arial"; // famille par defaut
	private AbstractColor  tokenColor = new ModifiableColor(0, 0, 0); // noir par defaut
	private AbstractColor  currentColor;
	
	public AbstractColor getCurrentColor()
	{
		return currentColor;
	} // getCurrentColor()

	private void setCurrentColor (AbstractColor currentColor)
	{
		this.currentColor = currentColor;
	} // setCurrentColor ()

	public AbstractColor getTokenColor()
	{
		return tokenColor;
	} // getTokenColor()

	public void setTokenColor (AbstractColor tokenColor)
	{
		this.tokenColor = tokenColor;
		currentColor = tokenColor;
	} // setTokenColor ()

	public String getFontFamily() 
	{
		return fontFamily;
	} // getFontFamily()

	public void setFontFamily (String fontFamily)
	{
		this.fontFamily = fontFamily;
	} // setFontFamily()

	public void selectToken ()
	{
		// selection du Token: on lui affecte la couleur correspondante
		setCurrentColor(selectedTokenColor);
	} // selectToken ()
	
	public void deselectToken ()
	{
		// deselection du Token: retour a sa couleur normale
		setCurrentColor(tokenColor);
	} // deselectToken ()
	
	public static String toCSS (AbstractColor color)
	{
		return "rgb(" + color.getRedComponent()
					+ ", " + color.getGreenComponent()
					+ ", " + color.getBlueComponent()
					+ ")";
	} // toCSS ()
	
	public String toString ()
	{
		return "<span style='font-family: " + fontFamily
				+ "; color: " + toCSS (getCurrentColor())
				+ "'>"
				+ super.toString()
				+ "</span>";
	} // toString ()
} // class TokenHTML
