package sajous.litl.token;

public class Token
{	
	private final static int STEM_LENGTH = 7;
	private String wordForm;
	private String lemma;
	private String POS; 
	private int index;
	private int govIndex;
	private String depLabel;
	
	public int getIndex()
	{
		return index;
	}

	public void setIndex(int i)
	{
		index = i;
	}

	public int getGovIndex()
	{
		return govIndex;
	}

	public void setGovIndex(int gi)
	{
		govIndex = gi;
	}

	public String getDepLabel()
	{
		return depLabel;
	}

	public void setDepLabel(String depLbl)
	{
		depLabel = depLbl;
	}

	public String getWordForm()
	{
		return wordForm;
	}

	public void setWordForm(String wf)
	{
		wordForm = wf;
	}

	public void setLemma (String l)
	{
		lemma = l;
	}
	
	public String getLemma ()
	{
		return lemma;		
	}
	
	public String getPOS()
	{
		return POS;
	}

	public void setPOS(String pOS)
	{
		POS = pOS;
	}

	public String getStem ()
	{
		if (wordForm.length() > STEM_LENGTH)
			return wordForm.substring(0, STEM_LENGTH);
		else
			return wordForm;
	}
	
	public void displayWithLemma ()
	{
		System.out.println(wordForm + "\t" + POS + "\t" + lemma);
	}
	
	public void displayWithStem ()
	{
		System.out.println(wordForm + "\t" + POS + "\t" + getStem());
	}

	public void displayBoth ()
	{
		displayWithLemma();
		displayWithStem();
	}
	
	public String toString ()
	{
		return getPOS() + ":" + getLemma();
	}
	
	public boolean isVerb ()
	{
		return getPOS().startsWith("V");
	}
	
	public boolean isInflectedVerb ()
	{
		return getPOS().startsWith("V");
	}
	
	public boolean isInfinitive ()
	{
		return getPOS().startsWith("V");
	}
	

}
