package sajous.litl.geom;

import sajous.litl.colors.ModifiableColor;
import sajous.litl.colors.ReferenceColor;

public class TestGeomObjects
{
	public static void testConsole ()
	{
		FixedPoint fp = new FixedPoint(3, 2);
		System.out.println(fp.toString());
		fp.setObjName("PointFixe 1");
		System.out.println(fp.toString());
		
		FixedPoint fp2 = new FixedPoint(-5, 6, "PtFx2");
		System.out.println(fp2);
		
		MobilePoint mp1 = new MobilePoint();
		System.out.println(mp1.toString());
		mp1 = new MobilePoint(2, 5);
		MobilePoint mp2 = new MobilePoint(2, 5);
		
		System.out.println(mp1.toString());
		System.out.println(mp2.toString());
		
		System.out.println("Test egalite : m1 == m2 ? " + (mp1 == mp2));
		
		mp2.translate(-1, 3);
		System.out.println(mp2.toString());
		
		Segment sgmt = new Segment(mp1, mp2, "Seg1");
		System.out.println(sgmt.toString());
		sgmt.getEndPoint1().setObjName("A");
		sgmt.getEndPoint2().setObjName("B");
		System.out.println(sgmt.toString());

		// test de la translation sur le segment
		sgmt.translate(5, -6);
		System.out.println(sgmt.toString());
		
		// test de la classe Circle
		Circle c1 = new Circle(mp1, 3);
		System.out.println(c1.toString());
		c1.translate(-2, 25);
		System.out.println(c1.toString());
		
		Circle c2 = new Circle(3, -5, 1, "C2");
		System.out.println("\n" + c2.toString());
		c2.getCenter().setObjName("CentreC2");
		c2.translate(-1, -2);
		System.out.println(c2.toString());
		
		Group g1 = new Group("G1");
		g1.addObj(c2);
		g1.addObj(fp2);
		System.out.println("\n" + g1.toString());
		
		Group g2 = new Group("G2");
		g2.addObj(sgmt);
		g2.addObj(g1);
		g2.addObj(c1);
		System.out.println("\n" + g2 + "\n");
		
		g1.removeObj(sgmt);
		g1.removeObj(c2);
		System.out.println(g2);
		
		System.out.println("G2's span:");
		System.out.println("\tHorizontal span = " + g2.getHorizontalSpan());
		System.out.println("\tVertical span = " + g2.getVerticalSpan());
	} // testConsole ()
	
	public static void testGraphique ()
	{
		FixedPoint fp = new FixedPoint(3, 2);
		System.out.println(fp.toString());
		fp.setObjName("PointFixe 1");
		fp.setObjColor(new ModifiableColor(123, 20, 200));
		
		FixedPoint fp2 = new FixedPoint(400, 300, "PtFx2");		
		
		MobilePoint mp1 = new MobilePoint();		
		mp1 = new MobilePoint(0, 0);
		MobilePoint mp2 = new MobilePoint(800, 600);
		
		Segment sgmt = new Segment(mp1, mp2, "Seg1");
		sgmt.getEndPoint1().setObjName("A");
		sgmt.getEndPoint2().setObjName("B");
		sgmt.setObjColor(ReferenceColor.RED);

		// test de la classe Circle
		Circle c1 = new Circle(200, 150, 150);
		c1.setObjColor(ReferenceColor.BLUE);
		
		Circle c2 = new Circle(500, 300, 200, "C2");
		c2.setObjColor(new ModifiableColor(0, 180, 40));
		
		Group g1 = new Group("G1");
		g1.addObj(c2);
		g1.addObj(fp2);
		
		Group g2 = new Group("G2");
		g2.addObj(sgmt);
		g2.addObj(g1);
		g2.addObj(c1);

		System.out.println(g2);
	} // testGraphique ()
	
	public static void main (String[] args)
	{
		testConsole();
		//testGraphique();
	} // main ()
} // class TestGeomObjects
