package sajous.litl.geom;

public class Segment extends GeomObject implements Mobile
{
	private MobilePoint endPoint1 = null;
	private MobilePoint endPoint2 = null;
	
	public Segment (MobilePoint endPoint1, MobilePoint endPoint2)
	{
		this.endPoint1 = endPoint1;
		this.endPoint2 = endPoint2;
	} // public Segment ()
	
	public Segment (MobilePoint endPoint1, MobilePoint endPoint2, String objName)
	{
		this (endPoint1, endPoint2);
		setObjName(objName);
	} // public Segment ()
	
	public MobilePoint getEndPoint1()
	{
		return endPoint1;
	} // getEndPoint1()

	public void setEndPoint1 (MobilePoint endPoint1)
	{
		this.endPoint1 = endPoint1;
	} // setEndPoint1 ()

	public MobilePoint getEndPoint2()
	{
		return endPoint2;
	} // getEndPoint2()

	public void setEndPoint2 (MobilePoint endPoint2)
	{
		this.endPoint2 = endPoint2;
	} // setEndPoint2 ()

	// Implementation possible mais non souhaitable 
	/*
	public void translate (int dx, int dy)
	{
		getEndPoint1().setX (getEndPoint1().getX() + dx);
		getEndPoint2().setY (getEndPoint2().getY() + dy);
	} // translate ()
	*/
	
	public void translate (int dx, int dy)
	{
		getEndPoint1().translate(dx, dy);
		getEndPoint2().translate(dx, dy);
	} // translate ()
	
	
	public String toString ()
	{
		return getObjName() + " [Segment: ep1="
				+ getEndPoint1().toString()
				+ ", ep2=" + getEndPoint2().toString()
				+ ", color=" + getObjColor().toString()
				+ "]";
	} // toString ()


	public int getMaxX ()
	{
		return Math.max(getEndPoint1().getX(), getEndPoint2().getX());
	} // getMaxX ()
	
	public int getMinX ()
	{
		return Math.min(getEndPoint1().getX(), getEndPoint2().getX());
	} // getMinX ()
	
	public int getMaxY ()
	{
		return Math.max(getEndPoint1().getY(), getEndPoint2().getY());
	} // getMaxY()
	
	public int getMinY ()
	{
		return Math.min(getEndPoint1().getY(), getEndPoint2().getY());
	} // getMinY()
} // extends GeomObject ()