package sajous.litl.geom;

public abstract class Point extends GeomObject
{
	protected int x; // abs
	protected int y; // ord
	
	public Point ()
	{
		// initialisation par defaut
		x = 0;
		y = 0;
	} // Point ()
	
	public Point (int x, int y)
	{
		this.x = x;
		this.y = y;
	} // Point ()
	
	public int getX ()
	{
		return x;
	} // getX ()
	
	public int getY ()
	{
		return y;
	} // getY ()
	
	public String getCoordsRepresentation ()
	{
		return "(x = " + String.valueOf(x)
				+ ", y = " + String.valueOf(y)
				+ ")";
	} // getCoordsRepresentation ()
	
	/**
	 * Commentaire sur cette methode toString()
	 * 
	 * Il existe dans l'API une classe de type Class (cf. doc)
	 * la methode getClass() definie dans la classe Object,
	 * invoquee sur un objet de n'importe quelle classe,
	 * renvoie une instance de la classe Class.
	 * Cette classe possede plusieurs methodes, dont getName() et getSimpleName()
	 * qui renvoient le nom de la classe.
	 * 
	 * Les methodes toString() de MobilePoint et FixedPoint ont ete commentees
	 * C'est donc la methode ci-dessous qui s'execute quand on invoque toString()
	 * sur une instance de MobilePoint ou FixedPoint.
	 * Bien que definie dans la classe Point, la methode getClass()
	 * renvoie une instance de la classe de l'objet sur laquelle la methode a ete invoquee.
	 * Ce qui explique que (on le voit dans la trace d'execution),
	 * le resultat de getClasse().getSimpleName() est ici
	 * "FixedPoint" ou "MobilePoint" et pas "Point". 
	 */
	public String toString ()
	{
		return getObjName() + " ["
				+ getClass().getSimpleName()
				+ " " + getCoordsRepresentation()
				+ "]";
	} // toString ()
	
	public int getMaxX ()
	{
		return getX();
	} // getMaxX ()
	
	public int getMinX ()
	{
		return getX();
	} // getMinX ()
	
	public int getMaxY ()
	{
		return getY();
	} // getMaxY()
	
	public int getMinY ()
	{
		return getY();
	} // getMinY()
} // class Point
