package sajous.litl.geom;

public class MobilePoint extends Point implements Mobile
{
	// surdefinition du constructeur par defaut
	// les coordonnees sont positionnees par defaut a l'origine du repere (0, 0)
	public MobilePoint ()
	{
		super (); // traitements par defaut delegues à la classe mere
	} // MobilePoint ()
	
	public MobilePoint (int x, int y)
	{
		/*
		 * appel au constructeur de la classe mere qui prend
		 * les coordonnees en arguments
		 * (et qui saura quoi en faire)
		 */
		super (x, y);
	} // MobilePoint ()
	
	public MobilePoint (int x, int y, String objName)
	{		
		this(x, y);
		setObjName(objName);		
	} // MobilePoint ()
	
	public MobilePoint (String objName)
	{
		this (); // appel du constructeur par defaut pour positionner x et y a (0, 0)
		setObjName(objName);
	} // MobilePoint ()	
	
	public void setX (int x)
	{
		this.x = x;
	} // setX ()

	public void setY (int y)
	{
		this.y = y;
	} // setY ()
	
	public void translate (int dx, int dy)
	{
		setX (getX() + dx);
		setY (getY() + dy);
	} // translate ()
	
	/*
	public String toString ()
	{
		return getObjName() + " [MobilePoint "
				+ getCoordsRepresentation()
				+ "]";
	} // toString ()
	*/
} // class MobilePoint
