package sajous.litl.geom;

import java.util.*;

public class Group extends GeomObject implements Mobile
{
	private List<GeomObject> objList = new ArrayList<GeomObject>();
	
	public Group ()
	{
	} // Group ()
	
	public Group (String groupName)
	{
		setObjName(groupName);
	} // Group ()
	
	public void addObj (GeomObject obj)
	{
		objList.add(obj);
	} // addObj ()
	
	public void removeObj (GeomObject obj)
	{
		if (objList.contains(obj))
			objList.remove(obj);
		else
			System.out.println("Group/removeObj(): Attention ! Tentative de supprimer l'objet "
					+ obj.toString() + " du groupe "
					+ toString()
					+ " qui ne le contient pas.");
	} // removeObj ()

	public int getMaxX ()
	{
		int result = Integer.MIN_VALUE;
		
		Iterator<GeomObject> goIt = objList.iterator();
		while (goIt.hasNext())
		{
			GeomObject currentObj = goIt.next();
			result = Math.max(result, currentObj.getMaxX());
		} // while (goIt.hasNext())
		
		return result;
	} // getMaxX ()
	
	public int getMinX ()
	{
		int result = Integer.MAX_VALUE;
		
		Iterator<GeomObject> goIt = objList.iterator();
		while (goIt.hasNext())
		{
			GeomObject currentObj = goIt.next();
			result = Math.min(result, currentObj.getMinX());
		} // while (goIt.hasNext())
		
		return result;
	} // getMinX ()
	
	public int getMaxY ()
	{
		int result = Integer.MIN_VALUE;
		
		Iterator<GeomObject> goIt = objList.iterator();
		while (goIt.hasNext())
		{
			GeomObject currentObj = goIt.next();
			result = Math.max(result, currentObj.getMaxY());
		} // while (goIt.hasNext())
		
		return result;
	} // getMaxY()
	
	public int getMinY ()
	{
		int result = Integer.MAX_VALUE;
		
		Iterator<GeomObject> goIt = objList.iterator();
		while (goIt.hasNext())
		{
			GeomObject currentObj = goIt.next();
			result = Math.min(result, currentObj.getMinY());
		} // while (goIt.hasNext())
		
		return result;
	} // getMinY()

	public int getHorizontalSpan()
	{
		return getMaxX() - getMinX();
	} // getHorizontalSpan()

	public int getVerticalSpan()
	{
		return getMaxY() - getMinY();
	} // getVerticalSpan()

	public String toString ()
	{
		String result = getObjName() + " [Group:";
		
		// pour chaque objet du groupe, on ajoute
		// la representation textuelle de l'objet
		// a la chaine result
		Iterator<GeomObject> it = objList.iterator();
		
		while (it.hasNext())
		{
			GeomObject gObj = it.next();
			result += ("\n\t" + gObj.toString());
		} // while (it.hasNext())
		
		result += "]";
		
		return result;
	} // toString ()
	
	// bof bof
	public void translate1 (int dx, int dy)
	{
		Iterator<GeomObject> goIt = objList.iterator();
		
		while (goIt.hasNext())
		{
			GeomObject currentObj = goIt.next(); 
			
			if (currentObj instanceof MobilePoint)
				((MobilePoint) currentObj).translate(dx, dy);
			else if (currentObj instanceof Circle)
				((Circle) currentObj).translate(dx, dy);
			else if (currentObj instanceof Segment)
				((Segment) currentObj).translate(dx, dy);
			// ...
		} // while (goIt.hasNext())
	} // translate1 ()
	
	public void translate (int dx, int dy)
	{
		Iterator<GeomObject> goIt = objList.iterator();
		
		while (goIt.hasNext())
		{
			GeomObject currentObj = goIt.next(); 
			
			if (currentObj instanceof Mobile)
				((Mobile) currentObj).translate(dx, dy);
		} // while (goIt.hasNext())
	} // translate ()

} // class Group
