package sajous.litl.geom;

import sajous.litl.colors.*;

public abstract class GeomObject
{	
	private static int nbCreatedObjects = 0;
	private static AbstractColor defaultColor = ReferenceColor.BLACK;
	private AbstractColor objColor = null;
	private String objName = null;
	
	public GeomObject ()
	{
		nbCreatedObjects++;
		setObjName("anonymous_" + String.valueOf(nbCreatedObjects));
		setObjColor(defaultColor);
	} // GeomObject ()
	
	public abstract int getMaxX ();
	public abstract int getMinX ();
	public abstract int getMaxY ();
	public abstract int getMinY ();
	
	public void setObjColor (AbstractColor objColor)
	{
		this.objColor = objColor;
	} // setObjColor ()
	
	public AbstractColor getObjColor ()
	{
		return objColor;
	} // getObjColor ()
	
	public String getObjName()
	{
		return objName;
	} // getObjName()

	public void setObjName (String objName)
	{
		this.objName = objName;		
	} // setObjName()
	
	public String toString ()
	{
		return getObjName() + " [GeomObj]";
	} // toString ()
	
	public int getHorizontalSpan ()
	{
		return getMaxX() - getMinX();
	} // getHorizontalSpan ()
	
	public int getVerticalSpan ()
	{
		return getMaxY() - getMaxY();
	} // getVerticalSpan ()
} // class GeomObject
