package sajous.litl.geom;

public class Circle extends GeomObject implements Mobile
{
	private MobilePoint center = null;
	private int radius;

	public Circle (MobilePoint center, int radius)
	{
		this.center = center;
		this.radius = radius;
	} // Circle ()
	
	public Circle (MobilePoint center, int radius, String objName)
	{
		this (center, radius);
		setObjName(objName);
	} // Circle ()

	public Circle (int x, int y, int radius)
	{
		this.radius = radius;
		center = new MobilePoint (x, y);
	} // Circle ()
	
	public Circle (int x, int y, int radius, String objName)
	{
		this (x, y, radius);
		setObjName(objName);
	} // Circle ()

	public MobilePoint getCenter()
	{
		return center;
	} // getCenter()

	public void setCenter (MobilePoint center)
	{
		this.center = center;
	} // setCenter ()
	
	public int getRadius()
	{
		return radius;
	} // getRadius()
	
	public void setRadius (int radius)
	{
		this.radius = radius;
	} // setRadius ()
	
	public void translate (int dx, int dy)
	{
		// deplacer un cercle, c'est deplacer son centre
		getCenter().translate(dx, dy);
	} // translate ()
	
	public String toString ()
	{
		return getObjName() + " [Circle: center=" 
				+ getCenter().toString() 
				+ ", radius=" + getRadius()
				+ ", color=" + getObjColor().toString()
				+ "]"; 
	} // toString ()

	public int getMaxX ()
	{
		return getCenter().getX() + getRadius();
	} // getMaxX ()
	
	public int getMinX ()
	{
		return getCenter().getX() - getRadius();
	} // getMinX ()
	
	public int getMaxY ()
	{
		return getCenter().getY() + getRadius();
	} // getMaxY()
	
	public int getMinY ()
	{
		return getCenter().getY() - getRadius();
	} // getMinY()
} // class Circle
