package sajous.litl.colors;

import sajous.litl.token.TokenHTML;

public class TestColors
{
	public static void main (String args[])
	{
		AbstractColor mc = new ModifiableColor(AbstractColor.COMPONENT_MAX_VALUE, 0, 0);
		mc.display();

		// is mc red?
		System.out.println(mc == ReferenceColor.RED);		
		System.out.println(mc.sameAs(ReferenceColor.RED));
		
		TokenHTML th = new TokenHTML();
		th.setWordForm("Compilateurs");
		th.setLemma("compilateur");
		th.setPOS("NC");
		th.setFontFamily("Serif");
		
		th.setTokenColor(mc);
		System.out.println(th.toString());
		th.selectToken();
		
		System.out.println("Token sélectionné :");
		System.out.println(th.toString());
		th.deselectToken();

		System.out.println("Token désélectionné :");
		System.out.println(th.toString());
		
		// remarquez que l'on peut affecter a un TokenHTML
		// une couleur modifiable ou une couleur de reference
		th.setTokenColor(ReferenceColor.BLUE);
		System.out.println(th.toString());
	} // main ()
} // class TestColors
