package sajous.litl.colors;

public class ModifiableColor extends AbstractColor
{
	public ModifiableColor ()
	{
		super ();
	} // ModifiableColor ()
	
	public ModifiableColor (int redComponent, int greenComponent, int blueComponent)
	{
		super (redComponent, greenComponent, blueComponent);
	} // ModifiableColor ()
	
	public void setRedComponent (int redComponent)
	{
		this.redComponent = redComponent;
	} // setRedComponent ()
	
	public void setGreenComponent(int greenComponent)
	{
		this.greenComponent = greenComponent;
	} // setGreenComponent()
	
	public void setBlueComponent (int blueComponent)
	{
		this.blueComponent = blueComponent;
	} // setBlueComponent ()
	
	public void invert ()
	{
		setRedComponent(COMPONENT_MAX_VALUE - getRedComponent());
		setGreenComponent(COMPONENT_MAX_VALUE - getGreenComponent());
		setBlueComponent(COMPONENT_MAX_VALUE - getBlueComponent());
	} // invert ()
	
	public void greyScale ()
	{
		setRedComponent(Double.valueOf(0.2989 * (double) getRedComponent()).intValue());
		setGreenComponent(Double.valueOf((0.5870 * (double) getGreenComponent())).intValue());
		setBlueComponent(Double.valueOf((0.114 * (double) getBlueComponent())).intValue());
	} // greyScale ()
} // class ModifiableColor
