package sajous.litl.colors;

import java.awt.Color;

public abstract class AbstractColor
{
	public static final int COMPONENT_MAX_VALUE = 255;

	// default color = black: RGB(0, 0, 0)
	protected int redComponent   = 0;  
	protected int greenComponent = 0;
	protected int blueComponent  = 0;
	
	public AbstractColor ()
	{
	} // Color ()
	
	public AbstractColor (int redComponent, int greenComponent, int blueComponent)
	{
		this.redComponent = redComponent;
		this.greenComponent = greenComponent;
		this.blueComponent = blueComponent;
	} // Color ()
	
	public int getRedComponent()
	{
		return redComponent;
	} // getRedComponent()

	public int getGreenComponent()
	{
		return greenComponent;
	} // getGreenComponent()
	
	public int getBlueComponent ()
	{
		return blueComponent;
	} // getBlueComponent ()
	
	public boolean sameAs (AbstractColor otherColor)
	{
		return ((getRedComponent() == otherColor.getRedComponent())
				&& (getGreenComponent() == otherColor.getGreenComponent())
				&& (getBlueComponent() == otherColor.getBlueComponent()));
	} // sameAs ()
	
	public Color toJavaColor ()
	{
		return new Color (getRedComponent(),
							getGreenComponent(),
							getBlueComponent());
	} // toJavaColor ()
	
	public String toString ()
	{
		return "RGB(" + getRedComponent() + ", "
						+ getGreenComponent() + ", "
						+ getBlueComponent() + ")";
	} // toString ()
	
	public void display ()
	{
		System.out.println(toString());
	} // display ()
} // class Color
